#!/usr/bin/env bash
# --------------------------------------------------------------------------#
#  Copyright (C) 2022 by Tibit Communications, Inc.                         #
#  All rights reserved.                                                     #
#                                                                           #
#     _______ ____  _ ______                                                #
#    /_  __(_) __ )(_)_  __/                                                #
#     / / / / __  / / / /                                                   #
#    / / / / /_/ / / / /                                                    #
#   /_/ /_/_____/_/ /_/                                                     #
#                                                                           #
#                                                                           #
#  Distributed as Tibit-Customer confidential                               #
#                                                                           #
# --------------------------------------------------------------------------#

TMPFILE=$(mktemp /tmp/tibit_nc_rpc.XXXXXX)

usage () {
    cat <<HELP_USAGE

    $0  <new-ssh-port>

    Modify the NETCONF Server's TCP listen port number (default: 830).

HELP_USAGE

exit 0
}

# Parse command line arguments
[ -z $1 ] && { usage; }

NEW_PORT=$1

echo "Configuring NETCONF Server's TCP listen port number ${NEW_PORT}."

#
# Update Netopeer2's running configuration
#
cat >${TMPFILE}  << EDITCONFIGXML
<netconf-server xmlns="urn:ietf:params:xml:ns:yang:ietf-netconf-server">
  <listen>
    <endpoint>
      <name>default-ssh</name>
      <ssh>
        <tcp-server-parameters>
          <local-port>${NEW_PORT}</local-port>
        </tcp-server-parameters>
      </ssh>
    </endpoint>
  </listen>
</netconf-server>
EDITCONFIGXML

# Apply configuration to the running datastore.
echo "Applying NACM configuration from ${TMPFILE} to the running datastore..."
/opt/tibit/netconf/bin/sysrepocfg --edit=${TMPFILE} --module=ietf-netconf-server --format=xml --datastore=running
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

# Apply configuration to hte startup datastore.
echo "Applying NACM configuration from ${TMPFILE} to the startup datastore..."
/opt/tibit/netconf/bin/sysrepocfg --edit=${TMPFILE} --module=ietf-netconf-server --format=xml --datastore=startup
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

rm -rf ${TMPFILE}