#!/usr/bin/env bash
# --------------------------------------------------------------------------#
#  Copyright (C) 2022 by Tibit Communications, Inc.                         #
#  All rights reserved.                                                     #
#                                                                           #
#     _______ ____  _ ______                                                #
#    /_  __(_) __ )(_)_  __/                                                #
#     / / / / __  / / / /                                                   #
#    / / / / /_/ / / / /                                                    #
#   /_/ /_/_____/_/ /_/                                                     #
#                                                                           #
#                                                                           #
#  Distributed as Tibit-Customer confidential                               #
#                                                                           #
# --------------------------------------------------------------------------#

TMPFILE=$(mktemp /tmp/tibit_nc_rpc.XXXXXX)

usage () {
    cat <<HELP_USAGE

    $0  <file>

    Configure the Netconf Network Configuration Access Control Model (RFC8341).

HELP_USAGE

exit 0
}

# Check root access
if [[ $EUID > 0 ]]; then
  echo "Root level access is required. Please use 'sudo' to run the nacm-config.sh script."
  exit
fi

# Defaults

[ -z $1 ] && { usage; }

FILE=$1

echo "Configuring NACM for the NETCONF Server from ${FILE}."

# Apply configuration to the running datastore.
echo "Applying NACM configuration from ${FILE} to the running datastore..."
/opt/tibit/netconf/bin/sysrepocfg --import=${FILE} --module=ietf-netconf-acm --format=xml --datastore=running
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

# Apply configuration to hte startup datastore.
echo "Applying NACM configuration from ${FILE} to the startup datastore..."
/opt/tibit/netconf/bin/sysrepocfg --import=${FILE} --module=ietf-netconf-acm --format=xml --datastore=startup
if [ "$?" = "0" ]; then
    echo "Success."
else
    echo "Failed."
    exit 1
fi

exit 0
