"""
#--------------------------------------------------------------------------#
# Copyright (C) 2022 by Tibit Communications, Inc.                         #
# All rights reserved.                                                     #
#                                                                          #
#    _______ ____  _ ______                                                #
#   /_  __(_) __ )(_)_  __/                                                #
#    / / / / __  / / / /                                                   #
#   / / / / /_/ / / / /                                                    #
#  /_/ /_/_____/_/ /_/                                                     #
#                                                                          #
# Distributed as Tibit-Customer confidential.                              #
#                                                                          #
#--------------------------------------------------------------------------#
"""

from django.urls import path

from . import views

urlpatterns = [
    path('olt-firmware/', views.OltMetadata.as_view(), name='olt_firmware_info'),
    path('onu-firmware/', views.OnuMetadata.as_view(), name='onu_firmware_info'),
    path('olt-firmware/<str:filename>/', views.OltFiles.as_view(), name='olt_firmware_files'),
    path('onu-firmware/<str:filename>/', views.OnuFiles.as_view(), name='onu_firmware_files'),
    path('pictures/', views.PictureMetadata.as_view(), name='picture_info'),
    path('pictures/<str:filename>/', views.PictureFiles.as_view(), name='picture_files'),
]
